local t = Def.ActorFrame {};

local function tablelength(T)
  local count = 0
  for _ in pairs(T) do count = count + 1 end
  return count
end

Songs = SONGMAN:GetAllSongs();
Results = {};
currentResult = 1;

local function showResult(self, index)
	song = Results[index];
	
	local topScreen = SCREENMAN:GetTopScreen();
	local screenName = topScreen:GetName();
	if screenName == "ScreenSelectMusic" then
		local MusicWheel = topScreen:GetChild("MusicWheel");
		if MusicWheel ~= nil then
			MusicWheel:SelectSong(song);
			MusicWheel:Move(1); -- lazy fix to trigger CurrentSongChanged
			MusicWheel:Move(-1); -- lazy fix to trigger CurrentSongChanged
			MusicWheel:Move(0); -- lazy fix to trigger CurrentSongChanged
		end;
	end;
	
end;

local function searchSong(self ,searchString)
	if string.len(searchString) < 3 then
		return;
	end;
	
	searchString = string.lower(searchString);
	Results = {};
	text = "";
	n = 0;
	for k,v in pairs(Songs) do
		title = string.lower(v:GetDisplayFullTitle());
		if string.find(title,searchString) ~= nil and
		v:GetStepsSeconds() > 0.0 then
			text = text .. title .. "\n";
			n = n + 1;
			
			key = {song = v, i=n}
			table.insert(Results, n, v);
		end;
	end;
	
	local c = self:GetChildren();

	if tablelength(Results) > 0 then
		if tablelength(Results) == 1 then
			c.textfield2:settext(tablelength(Results) .. " Results found for \""..searchString.."\"");
		else
			c.textfield2:settext(tablelength(Results) .. " Results found for \""..searchString.."\"");
		end;
		
		currentResult = 1;
		showResult(self, currentResult);
	else
		c.textfield2:settext("No results were found.");
	end;
end;

local EnterSongName

local function EnterNameSong(event)
	if event.type == "InputEventType_Release" then return false end
	if event.DeviceInput.button == "DeviceButton_1" then
		EnterSongName:playcommand("SongName")
	elseif event.DeviceInput.button == "DeviceButton_2" then
		EnterSongName:playcommand("SearchSong")
	elseif event.DeviceInput.button == "DeviceButton_3" then
		EnterSongName:playcommand("SearchPrevSong")
	elseif event.DeviceInput.button == "DeviceButton_4" then
		EnterSongName:playcommand("SearchNextSong")
	end
	if GAMESTATE:IsEventMode() == true then
		if event.DeviceInput.button == "DeviceButton_9" then
			EnterSongName:playcommand("DebugSearch")
		end
	end
end

t[#t+1] = Def.ActorFrame{
	Name="SearchBar";
	InitCommand=function(self)
		EnterSongName=self
		self:xy(CenterX(),Bottom())
	end,
	OnCommand=function(self) SCREENMAN:GetTopScreen():AddInputCallback(EnterNameSong) end,
	
	SM_SearchMessageCommand = function(self,params)
		local c = self:GetChildren();
		c.textfield:settext(params.searchString);
	end;
	
	SongNameCommand = function(self, params)
		local c = self:GetChildren();
		c.textfield:settext("");
		local topScreen = SCREENMAN:GetTopScreen();
		local screenName = topScreen:GetName();
		if screenName == "ScreenSelectMusic" then
			SCREENMAN:AddNewScreenToTop("ScreenTextEntry");
			local searchSettings = {
				Question = "Enters Song Name:\n(Min Number of Characters: 3)",
				MaxInputLength = 255,
				OnOK = function(answer)
					MESSAGEMAN:Broadcast("SM_Search",{searchString = answer});
				end,
			};
			SCREENMAN:GetTopScreen():Load(searchSettings);
		end;
		return true;
	end;
	
	SearchSongCommand = function(self, params)
		local c = self:GetChildren();
		local searchString = c.textfield:GetText();
		if searchString ~= "Presiona para buscar..." then
			searchSong(self, searchString);
		end;
		return true;
	end;
	
	SearchPrevSongCommand = function(self, params)
		local c = self:GetChildren();
		if currentResult > 1 and currentResult <= tablelength(Results) then
			currentResult = currentResult - 1;
			showResult(self, currentResult);
		end;
		return true;
	end;
	
	SearchNextSongCommand = function(self, params)
		local c = self:GetChildren();
		if currentResult >= 1 and currentResult < tablelength(Results) then
			currentResult = currentResult + 1;
			showResult(self, currentResult);
		end;
		return true;
	end;
	
	DebugSearchCommand = function(self, params)
		local c = self:GetChildren();
		local searchString = c.textfield:GetText();
		-- DEBUG MODE (Experimental)
		-- The DebugMode won't works if EventMode is set to "Off". There's no way to activate it even with ForceOn command.
		-- This section will works as a Debug Mode for this Theme, the option "Debug Mode" must be set to "On"
		-- to let this script part works. Set to "Off" by default.
		
		-- This Command will be available anytime, even if DebugMode is set to Off.
		-- DebugMode Commands: Syntax "/dm [ForceOn]/[Off]"
		local dm = "/dm "
		if searchString == dm.."ForceOn" then WriteFile("DebugMode.cfg","On","Settings") c.textfield2:settext("Debug Mode set to \"ON\". Use 'Off' to deactivate it again.") end
		
		-- HelpWindow Commands: Syntax "/help". Use /x to close Help window.
		-- Show cmds.
		if searchString == "/help" then c.HelpBackground:playcommand("Show") c.HelpBackground2:playcommand("Show") c.HelpTitle:playcommand("Show") c.HelpText:playcommand("Show") c.ExitText:playcommand("Show") end
		if searchString == "/help" then c.DebugMode:playcommand("Show") c.DelSlotColor:playcommand("Show") c.SortOrder:playcommand("Show") c.GoTo:playcommand("Show") c.SetScreen:playcommand("Show") c.SetScreenAndGoto:playcommand("Show") end
		-- Hide cmds.
		if searchString == "/x" then c.HelpBackground:playcommand("Hide") c.HelpBackground2:playcommand("Hide") c.HelpTitle:playcommand("Hide") c.HelpText:playcommand("Hide") c.ExitText:playcommand("Hide") end
		if searchString == "/x" then c.DebugMode:playcommand("Hide") c.DelSlotColor:playcommand("Hide") c.SortOrder:playcommand("Hide") c.GoTo:playcommand("Hide") c.SetScreen:playcommand("Hide") c.SetScreenAndGoto:playcommand("Hide") end
		
		-- Those variables will works only if DebugMode is set to On.
		if LoadFile("DebugMode.cfg","Settings") == "On" then
		
			-- DebugMode Commands: Syntax "/dm [ForceOn]/[Off]"
			if string.match(searchString,dm) then
				if searchString == dm.."Off" then WriteFile("DebugMode.cfg","Off","Settings") c.textfield2:settext("Debug Mode set to \"OFF\". Use 'ForceOn' to activate it again.") end
			end
			
			-- DeleteSlotColor Commands: Syntax "/dsc [All]/[1..8]"
			local dsc = "/dsc "
			if string.match(searchString,dsc) then
				if searchString == dsc.."All" then ThemePrefs.Set("MQColorSlot1","EMPTY") ThemePrefs.Set("MQColorSlot2","EMPTY") ThemePrefs.Set("MQColorSlot3","EMPTY") ThemePrefs.Set("MQColorSlot4","EMPTY")
					ThemePrefs.Set("MQColorSlot5","EMPTY") ThemePrefs.Set("MQColorSlot6","EMPTY") ThemePrefs.Set("MQColorSlot7","EMPTY") ThemePrefs.Set("MQColorSlot8","EMPTY")
					c.textfield2:settext("Deleted \"ALL\" Theme Color Slots succesfully.") end
				if searchString == dsc.."1" then ThemePrefs.Set("MQColorSlot1","EMPTY") c.textfield2:settext("Theme Color \"SLOT #1\" deleted succesfully.") end
				if searchString == dsc.."2" then ThemePrefs.Set("MQColorSlot2","EMPTY") c.textfield2:settext("Theme Color \"SLOT #2\" deleted succesfully.") end
				if searchString == dsc.."3" then ThemePrefs.Set("MQColorSlot3","EMPTY") c.textfield2:settext("Theme Color \"SLOT #3\" deleted succesfully.") end
				if searchString == dsc.."4" then ThemePrefs.Set("MQColorSlot4","EMPTY") c.textfield2:settext("Theme Color \"SLOT #4\" deleted succesfully.") end
				if searchString == dsc.."5" then ThemePrefs.Set("MQColorSlot5","EMPTY") c.textfield2:settext("Theme Color \"SLOT #5\" deleted succesfully.") end
				if searchString == dsc.."6" then ThemePrefs.Set("MQColorSlot6","EMPTY") c.textfield2:settext("Theme Color \"SLOT #6\" deleted succesfully.") end
				if searchString == dsc.."7" then ThemePrefs.Set("MQColorSlot7","EMPTY") c.textfield2:settext("Theme Color \"SLOT #7\" deleted succesfully.") end
				if searchString == dsc.."8" then ThemePrefs.Set("MQColorSlot8","EMPTY") c.textfield2:settext("Theme Color \"SLOT #8\" deleted succesfully.") end
			end
			
			-- SortOrder Commands: Syntax "/so [SortOrder value]"
			local so = "/so "
			if string.match(searchString,so) then
				if searchString == so.."Preferred" then SCREENMAN:GetTopScreen():GetMusicWheel():ChangeSort(0) c.textfield2:settext("Sort Order set to \"PREFERRED\".")
				elseif searchString == so.."Group" then SCREENMAN:GetTopScreen():GetMusicWheel():ChangeSort(1) c.textfield2:settext("Sort Order set to \"GROUP\".")
				elseif searchString == so.."Title" then SCREENMAN:GetTopScreen():GetMusicWheel():ChangeSort(2) c.textfield2:settext("Sort Order set to \"TITLE\".")
				elseif searchString == so.."BPM" then SCREENMAN:GetTopScreen():GetMusicWheel():ChangeSort(3) c.textfield2:settext("Sort Order set to \"BPM\".")
				elseif searchString == so.."Artist" then SCREENMAN:GetTopScreen():GetMusicWheel():ChangeSort(6) c.textfield2:settext("Sort Order set to \"ARTIST\".")
				elseif searchString == so.."Genre" then SCREENMAN:GetTopScreen():GetMusicWheel():ChangeSort(7) c.textfield2:settext("Sort Order set to \"GENRE\".")
				elseif searchString == so.."NoviceMeter" then SCREENMAN:GetTopScreen():GetMusicWheel():ChangeSort(8) c.textfield2:settext("Sort Order set to \"NOVICE METER\".")
				elseif searchString == so.."EasyMeter" then SCREENMAN:GetTopScreen():GetMusicWheel():ChangeSort(9) c.textfield2:settext("Sort Order set to \"EASY METER\".")
				elseif searchString == so.."MediumMeter" then SCREENMAN:GetTopScreen():GetMusicWheel():ChangeSort(10) c.textfield2:settext("Sort Order set to \"MEDIUM METER\".")
				elseif searchString == so.."HardMeter" then SCREENMAN:GetTopScreen():GetMusicWheel():ChangeSort(11) c.textfield2:settext("Sort Order set to \"HARD METER\".")
				elseif searchString == so.."ExpertMeter" then SCREENMAN:GetTopScreen():GetMusicWheel():ChangeSort(12) c.textfield2:settext("Sort Order set to \"EXPERT METER\".") else c.textfield2:settext("Invalid SortOrder value.") end
			end
			
			-- Goto Commands: Syntax "/goto [NextScreen]/[PrevScreen]"
			local gt = "/goto "
			if string.match(searchString,gt) then
				if searchString == gt.."NextScreen" then SCREENMAN:GetTopScreen():StartTransitioningScreen("SM_GoToNextScreen")
				elseif searchString == gt.."PrevScreen" then SCREENMAN:GetTopScreen():StartTransitioningScreen("SM_GoToPrevScreen") else c.textfield2:settext("Invalid used argument.") end
			end
			
			-- SetScreen Commands: Syntax "/ss [Screen name]"
			local ss = "/ss "
			local screen = split(ss,searchString)
			if string.match(searchString,ss) then
				if THEME:HasMetric(screen[2],"Fallback") then SCREENMAN:GetTopScreen():SetNextScreenName(screen[2]) c.textfield2:settext("Next Screen set to \""..screen[2].."\"") else c.textfield2:settext("Invalid Screen name.") end
			end
			
			-- SetScreenAndGoto Commands: Syntax "/ssgo [Screen name]"
			local ssgt = "/ssgo "
			local screen = split(ssgt,searchString)
			if string.match(searchString,ssgt) then
				if THEME:HasMetric(screen[2],"Fallback") then SCREENMAN:GetTopScreen():SetNextScreenName(screen[2]) SCREENMAN:GetTopScreen():StartTransitioningScreen("SM_GoToNextScreen") else c.textfield2:settext("Invalid Screen name.") end
			end
		end
		return true;
	end;
	
	-- HelpList stuffs
	Def.Quad{
		Name="HelpBackground";
		InitCommand=cmd(y,-214;visible,false;setsize,356,256;diffuse,BoostColor(color(LoadFile("ThemeColor.cfg","Settings")),2));
		ShowCommand=cmd(visible,true;zoomy,0;smooth,0.02;zoomy,1);
		HideCommand=cmd(zoomy,1;smooth,0.03;zoomy,0);
	};
	Def.Quad{
		Name="HelpBackground2";
		InitCommand=cmd(y,-214;visible,false;setsize,348,248;diffuse,color(LoadFile("ThemeColor.cfg","Settings")));
		ShowCommand=cmd(visible,true;zoomy,0;smooth,0.02;zoomy,1);
		HideCommand=cmd(zoomy,1;smooth,0.03;zoomy,0);
	};
	LoadFont("Common normal") .. {
		Name="HelpTitle";
		Text="/HELP COMMANDS";
		InitCommand=cmd(y,-330;zoom,0;valign,0);
		ShowCommand=cmd(sleep,0.02;zoom,0.5);
		HideCommand=cmd(zoom,0);
	};
	LoadFont("Common normal") .. {
		Name="HelpText";
		Text="Those commands are available for use with the Debug Mode\nincluded on this Theme. Currently under development.";
		InitCommand=cmd(x,-166;y,-308;zoom,0;align,0,0;maxwidth,832);
		ShowCommand=cmd(sleep,0.02;zoom,0.4);
		HideCommand=cmd(zoom,0);
	};
	LoadFont("Common normal") .. {
		Name="ExitText";
		Text="Use /x to close this Help window.";
		InitCommand=cmd(y,-102;zoom,0);
		ShowCommand=cmd(sleep,0.02;zoom,0.4);
		HideCommand=cmd(zoom,0);
	};
	MisoBold()..{
		Name="DebugMode";
		Text="DEBUG MODE:\n/dm [ForceOn]/[Off]";
		InitCommand=cmd(x,-166;y,-270;zoom,0;diffuse,BoostColor(color(LoadFile("ThemeColor.cfg","Settings")),4);align,0,0);
		ShowCommand=cmd(sleep,0.02;zoom,0.5);
		HideCommand=cmd(zoom,0);
	};
	MisoBold()..{
		Name="DelSlotColor";
		Text="DELETE SLOT COLOR:\n/dsc [All]/[1..8]";
		InitCommand=cmd(x,-166;y,-270+20*2;zoom,0;diffuse,BoostColor(color(LoadFile("ThemeColor.cfg","Settings")),4);align,0,0);
		ShowCommand=cmd(sleep,0.02;zoom,0.5);
		HideCommand=cmd(zoom,0);
	};
	MisoBold()..{
		Name="SortOrder";
		Text="SORT ORDER:\n/so [SortOrder name]";
		InitCommand=cmd(x,-166;y,-270+20*4;zoom,0;diffuse,BoostColor(color(LoadFile("ThemeColor.cfg","Settings")),4);align,0,0);
		ShowCommand=cmd(sleep,0.02;zoom,0.5);
		HideCommand=cmd(zoom,0);
	};
	MisoBold()..{
		Name="GoTo";
		Text="GOTO:\n/goto [NextScreen]/[PrevScreen]";
		InitCommand=cmd(x,-166;y,-270+20*6;zoom,0;diffuse,BoostColor(color(LoadFile("ThemeColor.cfg","Settings")),4);align,0,0);
		ShowCommand=cmd(sleep,0.02;zoom,0.5);
		HideCommand=cmd(zoom,0);
	};
	MisoBold()..{
		Name="SetScreen";
		Text="SET SCREEN:\n/ss [Screen name]";
		InitCommand=cmd(x,8;y,-270;zoom,0;diffuse,BoostColor(color(LoadFile("ThemeColor.cfg","Settings")),4);align,0,0);
		ShowCommand=cmd(sleep,0.02;zoom,0.5);
		HideCommand=cmd(zoom,0);
	};
	MisoBold()..{
		Name="SetScreenAndGoto";
		Text="SET SCREEN AND GOTO:\n/ssgo [Screen name]";
		InitCommand=cmd(x,8;y,-270+20*2;zoom,0;diffuse,BoostColor(color(LoadFile("ThemeColor.cfg","Settings")),4);align,0,0);
		ShowCommand=cmd(sleep,0.02;zoom,0.5);
		HideCommand=cmd(zoom,0);
	};
	------------------------------------------------------------------------
	
	LoadFont("Common normal") .. {
		InitCommand=cmd(x,-212;y,-32;zoom,0.4;valign,0;maxwidth,340);
		Text=string.upper("Press 3 for Prev Song");
	};
	
	LoadFont("Common normal") .. {
		InitCommand=cmd(x,212;y,-32;zoom,0.4;valign,0;maxwidth,340);
		Text=string.upper("Press 4 for Next Song");
	};
	
	LoadFont("Common normal") .. {
		Name="textfield";
		InitCommand=cmd(y,-32;zoom,0.4;valign,0;maxwidth,640);
		Text=LoadFile("DebugMode.cfg","Settings") == "On" and string.upper("Press 1 to Enter Debug commands.") or string.upper("Press 1 to Enter Song name.");
	};
	
	LoadFont("Common normal") .. {
		Name="textfield2";
		InitCommand=cmd(y,-12;zoom,0.4;valign,0);
		Text=LoadFile("DebugMode.cfg","Settings") == "On" and string.upper("Press 9 to Use Debug Mode.") or string.upper("Press 2 to Search Songs.");
	};
	
	BeginCommand=function(self)
		self:SetUpdateFunction( UpdateSearchBar );
		self:SetUpdateRate( 1/30 );
	end;
};

return t